/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.fluids;

import io.github.fabricators_of_create.porting_lib.fluids.FluidType;
import io.github.fabricators_of_create.porting_lib.fluids.PortingLibFluids;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3610;

public final class FluidInteractionRegistry {
    private static final Map<FluidType, List<InteractionInformation>> INTERACTIONS = new HashMap<FluidType, List<InteractionInformation>>();

    public static synchronized void addInteraction(FluidType source, InteractionInformation interaction) {
        INTERACTIONS.computeIfAbsent(source, s -> new ArrayList()).add(interaction);
    }

    public static boolean canInteract(class_1937 level, class_2338 pos) {
        return FluidInteractionRegistry.canInteract(level, pos, true);
    }

    public static boolean canInteract(class_1937 level, class_2338 pos, boolean overrideVanilla) {
        class_3610 state = level.method_8316(pos);
        for (class_2350 direction : class_2404.field_34006) {
            class_2338 relativePos = pos.method_10093(direction.method_10153());
            List interactions = INTERACTIONS.getOrDefault(state.getFluidType(), Collections.emptyList());
            for (InteractionInformation interaction : interactions) {
                if (interaction.isVanilla() && !overrideVanilla || !interaction.predicate().test(level, pos, relativePos, state)) continue;
                interaction.interaction().interact(level, pos, relativePos, state);
                return true;
            }
        }
        return false;
    }

    static {
        FluidInteractionRegistry.addInteraction(PortingLibFluids.LAVA_TYPE, new InteractionInformation(PortingLibFluids.WATER_TYPE, fluidState -> fluidState.method_15771() ? class_2246.field_10540.method_9564() : class_2246.field_10445.method_9564(), true));
        FluidInteractionRegistry.addInteraction(PortingLibFluids.LAVA_TYPE, new InteractionInformation((level, currentPos, relativePos, currentState) -> level.method_8320(currentPos.method_10074()).method_27852(class_2246.field_22090) && level.method_8320(relativePos).method_27852(class_2246.field_10384), class_2246.field_22091.method_9564(), true));
    }

    public record InteractionInformation(HasFluidInteraction predicate, FluidInteraction interaction, boolean isVanilla) {
        public InteractionInformation(HasFluidInteraction predicate, FluidInteraction interaction) {
            this(predicate, interaction, false);
        }

        public InteractionInformation(FluidType type, class_2680 state) {
            this(type, (class_3610 fluidState) -> state);
        }

        public InteractionInformation(HasFluidInteraction predicate, class_2680 state) {
            this(predicate, state, false);
        }

        public InteractionInformation(HasFluidInteraction predicate, class_2680 state, boolean isVanilla) {
            this(predicate, (class_3610 fluidState) -> state, isVanilla);
        }

        public InteractionInformation(FluidType type, Function<class_3610, class_2680> getState) {
            this((class_1937 level, class_2338 currentPos, class_2338 relativePos, class_3610 currentState) -> level.method_8316(relativePos).getFluidType() == type, getState);
        }

        public InteractionInformation(FluidType type, Function<class_3610, class_2680> getState, boolean isVanilla) {
            this((class_1937 level, class_2338 currentPos, class_2338 relativePos, class_3610 currentState) -> level.method_8316(relativePos).getFluidType() == type, getState, isVanilla);
        }

        public InteractionInformation(HasFluidInteraction predicate, Function<class_3610, class_2680> getState) {
            this(predicate, getState, false);
        }

        public InteractionInformation(HasFluidInteraction predicate, Function<class_3610, class_2680> getState, boolean isVanilla) {
            this(predicate, (class_1937 level, class_2338 currentPos, class_2338 relativePos, class_3610 currentState) -> {
                level.method_8501(currentPos, (class_2680)getState.apply(currentState));
                level.method_20290(1501, currentPos, 0);
            }, isVanilla);
        }
    }

    @FunctionalInterface
    public static interface HasFluidInteraction {
        public boolean test(class_1937 var1, class_2338 var2, class_2338 var3, class_3610 var4);
    }

    @FunctionalInterface
    public static interface FluidInteraction {
        public void interact(class_1937 var1, class_2338 var2, class_2338 var3, class_3610 var4);
    }
}

